import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:admin_desktop/presentation/components/components.dart';

class NotificationInfoDialog extends StatelessWidget {
  final String? image;
  final String? name;
  final String? lastName;
  final String? info;
  final String? updatedAt;

  const NotificationInfoDialog(
      {super.key,
      this.image,
      this.name,
      this.lastName,
      this.info,
      this.updatedAt});

  @override
  Widget build(BuildContext context) {
    return Container(
        width: 300,
        decoration: BoxDecoration(borderRadius: BorderRadius.circular(10)),
        child: Padding(
          padding: const EdgeInsets.all(24.0),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                children: [
                  CommonImage(
                    url: image,
                    height: 50,
                    width: 50,
                    radius: 100,
                  ),
                  15.horizontalSpace,
                  Text(
                    '$name $lastName',
                    style: Style.interSemi(
                        size: 16,
                        color: Style.black),
                  ),
                ],
              ),
              16.verticalSpace,
              Text(
                info ?? '',
                style: Style.interRegular(
                    size: 14,
                    color: Style.black),
              ),
              15.verticalSpace,
              Text(
                updatedAt ?? '0',
                style: Style.interNormal(
                    size: 12,
                    color: Style.iconColor),
              ),
            ],
          ),
        ));
  }
}
